<?php
/**
 * @version   $Id: analytics.php 2381 2012-08-15 04:14:26Z btowles $
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */

defined('JPATH_BASE') or die();

gantry_import('core.gantryfeature');

/**
 * @package     gantry
 * @subpackage  features
 */
class GantryFeatureAnalytics extends GantryFeature
{

	var $_feature_name = 'analytics';

	function init()
	{
		/** @var $gantry Gantry */
		global $gantry;

		ob_start();
		// start of Google Analytics javascript
		?>
	var _gaq = _gaq || [];
	_gaq.push(['_setAccount', '<?php echo $this->get('code'); ?>']);
	_gaq.push(['_trackPageview']);

	(function() {
	var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();
	<?php
		// end of Google Analytics javascript
		$gantry->addInlineScript(ob_get_clean());
	}
}